<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class City extends Model 
{

    protected $table = 'cities';
    public $timestamps = true;
    protected $fillable = array('name', 'region_id');

    public function region()
    {
        return $this->belongsTo('App\Models\Region', 'region_id');
    }

    public function addresses()
    {
        return $this->hasMany('App\Models\Address');
    }

}